VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Baskets"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"32FA94A50011"
'
Option Base 0
Option Explicit

Implements ObjectControl

Private oDBaskets As DpkgBaskets.DBaskets

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDBaskets = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
       
    Set oObjectContext = GetObjectContext()
    Set oDBaskets = oObjectContext.CreateInstance("DpkgBaskets.DBaskets")
        
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub


Public Function GetBasketItems(ByVal vOrderID As Variant, ByVal vCustomerID As Variant) As Variant
    On Error GoTo GetBasketItemsErr
        
    Dim vResponse As Variant
    Dim vBasket As Variant
    Dim vBasketItem As Variant
    Dim vPrice As Variant
    Dim vPromotionCode As Variant
    Dim vPromotionEndDate As Variant
    Dim vTodaysPrice As Variant
            
    If vOrderID = "" Then
        Set vResponse = oDBaskets.GetOrder(vCustomerID)
        vOrderID = vResponse("OrderID")
        Trace "OrderID - " & vOrderID
    End If
    
    Set vResponse = oDBaskets.GetBasketItems(vOrderID)
    If Not vResponse("error") Then
    
        Set vBasket = vResponse("items")
                    
        For Each vBasketItem In vBasket
    
            vPrice = vBasketItem("price")
            vPromotionCode = vBasketItem("promotioncode")
            vPromotionEndDate = vBasketItem("promotionenddate")
                            
            vTodaysPrice = AdjustTodaysPrice(vPrice, vPromotionCode, vPromotionEndDate)
            vTodaysPrice = Format(vTodaysPrice, "$#,##0.00")
            vBasketItem.Add vTodaysPrice, Key:="todaysprice"
            
        Next
    
    End If

    oObjectContext.SetComplete
    Set GetBasketItems = vResponse
    
    Exit Function
    
GetBasketItemsErr:
    oObjectContext.SetAbort
    Set GetBasketItems = RaiseError("GetBasketItems")

End Function


Public Function AddItem(ByVal vOrderID As Variant, ByVal vCustomerID As Variant, ByVal vCatalogId As Variant, ByVal vNumItems As Variant) As Variant
    On Error GoTo AddItemErr
    
    Dim vResponse As Variant
    
    If vOrderID = "" Then
        Set vResponse = oDBaskets.GetOrder(vCustomerID)
        vOrderID = vResponse("OrderID")
    End If
    
    Set vResponse = oDBaskets.AddItem(vOrderID, vCatalogId, vNumItems)
    
    vResponse.Add vOrderID, "OrderID"
    oObjectContext.SetComplete
    Set AddItem = vResponse
    
    Exit Function
    
AddItemErr:
    oObjectContext.SetAbort
    Set AddItem = RaiseError("AddItem")
End Function

Public Function UpdateNumItems(ByVal vBasketId As Variant, ByVal vNumItems As Variant) As Variant
    On Error GoTo UpdateNumItemsErr
    
    Dim vResponse As Variant
        
    Set vResponse = oDBaskets.UpdateNumItems(vBasketId, vNumItems)
    
    oObjectContext.SetComplete
    Set UpdateNumItems = vResponse
    
    Exit Function
    
UpdateNumItemsErr:
    oObjectContext.SetAbort
    Set UpdateNumItems = RaiseError("UpdateNumItems")
End Function


Public Function EmptyBasket(ByVal vOrderID As Variant) As Variant
    On Error GoTo EmptyBasketErr

    Dim vResponse As Variant
    
    Set vResponse = oDBaskets.EmptyBasket(vOrderID)
    
    oObjectContext.SetComplete
    Set EmptyBasket = vResponse

    Exit Function
    
EmptyBasketErr:
    oObjectContext.SetAbort
    Set EmptyBasket = RaiseError("EmptyBasket")
End Function

